/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentToolkit;
import jade.core.BackEnd;
import jade.core.ContainerID;
import jade.core.FEConnectionManager;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.Location;
import jade.core.MicroRuntime;
import jade.core.NotFoundException;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.Specifier;
import jade.core.TimerDispatcher;
import jade.core.behaviours.Behaviour;
import jade.lang.acl.ACLMessage;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import jade.wrapper.AgentContainer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class FrontEndContainer
implements FrontEnd,
AgentToolkit,
Runnable {
    private static final String CONN_MGR_CLASS_DEFAULT = "jade.imtp.leap.JICP.BIFEDispatcher";
    Logger logger = Logger.getMyLogger(this.getClass().getName());
    private Hashtable localAgents = new Hashtable(1);
    private ContainerID myId;
    Vector platformAddresses;
    private AID amsAID;
    private AID dfAID;
    private Vector pending;
    private BackEnd myBackEnd;
    private FEConnectionManager myConnectionManager;
    private Properties configProperties;
    private boolean exiting = false;
    private boolean starting = true;

    FrontEndContainer(Properties p) {
        Vector specs;
        this.configProperties = p;
        String agents = this.configProperties.getProperty("agents");
        try {
            specs = Specifier.parseSpecifierList(agents);
            Vector<Specifier> successfulAgents = new Vector<Specifier>();
            Enumeration en = specs.elements();
            while (en.hasMoreElements()) {
                Specifier s = (Specifier)en.nextElement();
                try {
                    this.localAgents.put(s.getName(), this.initAgentInstance(s.getName(), s.getClassName(), s.getArgs()));
                    successfulAgents.addElement(s);
                }
                catch (Throwable t) {
                    this.logger.log(Logger.SEVERE, "Exception creating agent " + t);
                }
            }
            this.configProperties.setProperty("agents", Specifier.encodeSpecifierList(successfulAgents));
        }
        catch (Exception e1) {
            this.configProperties.setProperty("agents", null);
            this.logger.log(Logger.SEVERE, "Exception parsing agent specifiers " + e1);
            e1.printStackTrace();
        }
        try {
            String connMgrClass = this.configProperties.getProperty("connection-manager");
            if (connMgrClass == null) {
                connMgrClass = CONN_MGR_CLASS_DEFAULT;
            }
            this.myConnectionManager = (FEConnectionManager)Class.forName(connMgrClass).newInstance();
            this.myBackEnd = this.myConnectionManager.getBackEnd(this, this.configProperties);
            this.initInfo(this.configProperties);
            this.logger.log(Logger.INFO, "--------------------------------------\nAgent container " + this.myId.getName() + " is ready.\n--------------------------------------------");
        }
        catch (IMTPException imtpe) {
            this.logger.log(Logger.SEVERE, "IMTP error " + imtpe);
            imtpe.printStackTrace();
            MicroRuntime.handleTermination(true);
            return;
        }
        catch (Exception e) {
            this.logger.log(Logger.SEVERE, "Unexpected error " + e);
            e.printStackTrace();
            MicroRuntime.handleTermination(true);
            return;
        }
        agents = this.configProperties.getProperty("agents");
        try {
            specs = Specifier.parseSpecifierList(agents);
            Enumeration e = specs.elements();
            while (e.hasMoreElements()) {
                Specifier sp = (Specifier)e.nextElement();
                Agent a = (Agent)this.localAgents.remove(sp.getName());
                if (a != null) {
                    Object[] args = sp.getArgs();
                    if (args != null && args.length > 0) {
                        this.logger.log(Logger.SEVERE, "Error starting agent " + sp.getName() + ". " + sp.getClassName() + " " + args[0]);
                        continue;
                    }
                    String actualName = sp.getClassName();
                    this.localAgents.put(actualName, a);
                    AID id = new AID(actualName, false);
                    a.powerUp(id, new Thread(a));
                    continue;
                }
                this.logger.log(Logger.WARNING, "Agent " + sp.getName() + " not found locally.");
            }
        }
        catch (Exception e1) {
            this.logger.log(Logger.SEVERE, "Exception parsing agent specifiers " + e1);
            e1.printStackTrace();
        }
        this.configProperties.remove("agents");
        this.notifyStarted();
    }

    public final void createAgent(String name, String className, String[] args) throws IMTPException {
        try {
            Agent a = this.initAgentInstance(name, className, args);
            String newName = this.myBackEnd.bornAgent(name);
            this.localAgents.put(newName, a);
            AID id = new AID(newName, false);
            a.powerUp(id, new Thread(a));
        }
        catch (Exception e) {
            String msg = "Exception creating new agent. ";
            this.logger.log(Logger.SEVERE, msg + e);
            throw new IMTPException(msg, e);
        }
    }

    public final void killAgent(String name) throws NotFoundException, IMTPException {
        this.waitUntilStarted();
        Agent agent = (Agent)this.localAgents.get(name);
        if (agent == null) {
            System.out.println("FrontEndContainer killing: " + name + " NOT FOUND");
            throw new NotFoundException("KillAgent failed to find " + name);
        }
        agent.doDelete();
    }

    public final void suspendAgent(String name) throws NotFoundException, IMTPException {
        this.waitUntilStarted();
        Agent agent = (Agent)this.localAgents.get(name);
        if (agent == null) {
            throw new NotFoundException("SuspendAgent failed to find " + name);
        }
        agent.doSuspend();
    }

    public final void resumeAgent(String name) throws NotFoundException, IMTPException {
        this.waitUntilStarted();
        Agent agent = (Agent)this.localAgents.get(name);
        if (agent == null) {
            throw new NotFoundException("ResumeAgent failed to find " + name);
        }
        agent.doActivate();
    }

    public final void messageIn(ACLMessage msg, String receiver) throws NotFoundException, IMTPException {
        this.waitUntilStarted();
        if (receiver != null) {
            Agent agent = (Agent)this.localAgents.get(receiver);
            if (agent == null) {
                throw new NotFoundException("Receiver " + receiver + " not found");
            }
            agent.postMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exit(boolean self) throws IMTPException {
        if (!this.exiting) {
            this.exiting = true;
            this.logger.log(Logger.INFO, "Container shut down activated");
            Hashtable hashtable = this.localAgents;
            synchronized (hashtable) {
                Enumeration e = this.localAgents.elements();
                while (e.hasMoreElements()) {
                    Agent a = (Agent)e.nextElement();
                    a.doDelete();
                    a.join();
                    a.resetToolkit();
                }
                this.localAgents.clear();
            }
            this.logger.log(Logger.FINE, "Local agents terminated");
            this.myConnectionManager.shutdown();
            this.logger.log(Logger.FINE, "Connection manager closed");
            MicroRuntime.handleTermination(self);
            TimerDispatcher.getTimerDispatcher().stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void synch() throws IMTPException {
        Hashtable hashtable = this.localAgents;
        synchronized (hashtable) {
            Enumeration e = this.localAgents.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.logger.log(Logger.INFO, "Resynching agent " + name);
                try {
                    this.myBackEnd.bornAgent(name);
                }
                catch (IMTPException imtpe) {
                    this.logger.log(Logger.WARNING, "IMTPException resynching. " + imtpe);
                    throw imtpe;
                }
                catch (Exception ex) {
                    this.logger.log(Logger.SEVERE, "Exception resynching agent " + name + ". " + ex);
                    ex.printStackTrace();
                }
            }
        }
    }

    private synchronized void waitUntilStarted() {
        try {
            while (this.starting) {
                this.wait();
            }
        }
        catch (Exception e) {}
    }

    private synchronized void notifyStarted() {
        this.starting = false;
        this.notifyAll();
    }

    public AgentContainer getContainerController(JADEPrincipal principal, Credentials credentials) {
        return null;
    }

    public final Location here() {
        return this.myId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void handleEnd(AID agentID) {
        String name = agentID.getLocalName();
        if (this.pending != null) {
            Vector vector = this.pending;
            synchronized (vector) {
                while (this.pending.contains(name)) {
                    try {
                        this.pending.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.exiting) return;
        try {
            this.localAgents.remove(name);
            this.myBackEnd.deadAgent(name);
            if (!"true".equals(this.configProperties.getProperty("exitwhenempty"))) return;
            if (!this.localAgents.isEmpty()) return;
            this.exit(true);
            return;
        }
        catch (IMTPException re) {
            this.logger.log(Logger.SEVERE, re.toString());
            return;
        }
    }

    public final void handleChangedAgentState(AID agentID, int from, int to) {
    }

    public final void handleSend(ACLMessage msg, AID sender, boolean needClone) {
        Iterator it = msg.getAllIntendedReceiver();
        boolean hasRemoteReceivers = false;
        while (it.hasNext()) {
            AID id = (AID)it.next();
            Agent a = (Agent)this.localAgents.get(id.getLocalName());
            if (a != null) {
                ACLMessage m = (ACLMessage)msg.clone();
                a.postMessage(m);
                continue;
            }
            hasRemoteReceivers = true;
        }
        if (hasRemoteReceivers) {
            this.post(msg, sender.getLocalName());
        }
    }

    public final void setPlatformAddresses(AID id) {
        id.clearAllAddresses();
        int i = 0;
        while (i < this.platformAddresses.size()) {
            id.addAddresses((String)this.platformAddresses.elementAt(i));
            ++i;
        }
    }

    public final AID getAMS() {
        return this.amsAID;
    }

    public final AID getDefaultDF() {
        return this.dfAID;
    }

    public String getProperty(String key, String aDefault) {
        String ret = this.configProperties.getProperty(key);
        return ret != null ? ret : aDefault;
    }

    public void handleMove(AID agentID, Location where) throws JADESecurityException, IMTPException, NotFoundException {
    }

    public void handleClone(AID agentID, Location where, String newName) throws JADESecurityException, IMTPException, NotFoundException {
    }

    public void handleSave(AID agentID, String repository) throws ServiceException, NotFoundException, IMTPException {
    }

    public void handleReload(AID agentID, String repository) throws ServiceException, NotFoundException, IMTPException {
    }

    public void handleFreeze(AID agentID, String repository, ContainerID bufferContainer) throws ServiceException, NotFoundException, IMTPException {
    }

    public void handlePosted(AID agentID, ACLMessage msg) {
    }

    public void handleReceived(AID agentID, ACLMessage msg) {
    }

    public void handleBehaviourAdded(AID agentID, Behaviour b) {
    }

    public void handleBehaviourRemoved(AID agentID, Behaviour b) {
    }

    public void handleChangeBehaviourState(AID agentID, Behaviour b, String from, String to) {
    }

    public ServiceHelper getHelper(Agent a, String serviceName) throws ServiceException {
        String helperClassName = this.configProperties.getProperty(serviceName);
        if (helperClassName != null) {
            try {
                ServiceHelper sh = (ServiceHelper)Class.forName(helperClassName).newInstance();
                return sh;
            }
            catch (Throwable t) {
                throw new ServiceException("Error creating helper for service " + serviceName, t);
            }
        }
        throw new ServiceException("Missing helper class name for service " + serviceName);
    }

    private final void initInfo(Properties pp) {
        this.myId = new ContainerID(pp.getProperty("container-name"), null);
        AID.setPlatformID(pp.getProperty("platform-id"));
        this.platformAddresses = Specifier.parseList(pp.getProperty("addresses"), ';');
        this.amsAID = new AID("ams", false);
        this.setPlatformAddresses(this.amsAID);
        this.dfAID = new AID("df", false);
        this.setPlatformAddresses(this.dfAID);
    }

    private final Agent initAgentInstance(String name, String className, Object[] args) throws Exception {
        Agent agent = (Agent)Class.forName(className).newInstance();
        agent.setArguments(args);
        agent.setToolkit(this);
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(ACLMessage msg, String sender) {
        if (this.pending == null) {
            this.pending = new Vector(4);
            Thread t = new Thread(this);
            t.start();
        }
        Vector vector = this.pending;
        synchronized (vector) {
            this.pending.addElement(msg.clone());
            this.pending.addElement(sender);
            int size = this.pending.size();
            if (size > 100 && size < 110) {
                this.logger.log(Logger.INFO, size + " pending messages");
            }
            this.pending.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ACLMessage msg = null;
        String sender = null;
        while (true) {
            Vector vector = this.pending;
            synchronized (vector) {
                while (this.pending.size() == 0) {
                    try {
                        this.pending.wait();
                    }
                    catch (InterruptedException ie) {
                        this.logger.log(Logger.SEVERE, ie.toString());
                    }
                }
                msg = (ACLMessage)this.pending.elementAt(0);
                sender = (String)this.pending.elementAt(1);
                this.pending.removeElementAt(1);
                this.pending.removeElementAt(0);
            }
            try {
                this.myBackEnd.messageOut(msg, sender);
            }
            catch (Exception e) {
                this.logger.log(Logger.SEVERE, e.toString());
            }
            Vector vector2 = this.pending;
            synchronized (vector2) {
                this.pending.notifyAll();
            }
        }
    }
}

